/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.os.rdos;

import com.webcodepro.applecommander.storage.DiskFullException;
import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FileFilter;
import com.webcodepro.applecommander.storage.FormattedDisk;
import com.webcodepro.applecommander.storage.StorageBundle;
import com.webcodepro.applecommander.storage.filters.ApplesoftFileFilter;
import com.webcodepro.applecommander.storage.filters.BinaryFileFilter;
import com.webcodepro.applecommander.storage.filters.GraphicsFileFilter;
import com.webcodepro.applecommander.storage.filters.IntegerBasicFileFilter;
import com.webcodepro.applecommander.storage.filters.TextFileFilter;
import com.webcodepro.applecommander.storage.os.rdos.RdosFormatDisk;
import com.webcodepro.applecommander.util.AppleUtil;
import com.webcodepro.applecommander.util.TextBundle;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;

public class RdosFileEntry
implements FileEntry {
    private TextBundle textBundle = StorageBundle.getInstance();
    private byte[] fileEntry;
    private RdosFormatDisk disk;

    public RdosFileEntry(byte[] fileEntry, RdosFormatDisk disk) {
        this.fileEntry = fileEntry;
        this.disk = disk;
    }

    public int getSizeInBlocks() {
        return AppleUtil.getUnsignedByte(this.fileEntry[25]);
    }

    public int getStartingBlock() {
        return AppleUtil.getWordValue(this.fileEntry, 30);
    }

    public int getAddress() {
        return AppleUtil.getWordValue(this.fileEntry, 26);
    }

    @Override
    public String getFilename() {
        return this.isDeleted() ? this.textBundle.get("RdosFileEntry.NotInUse") : AppleUtil.getString(this.fileEntry, 0, 24).trim();
    }

    @Override
    public void setFilename(String filename) {
    }

    @Override
    public int getMaximumFilenameLength() {
        return 24;
    }

    @Override
    public String getFiletype() {
        return this.isDeleted() ? " " : AppleUtil.getString(this.fileEntry, 24, 1);
    }

    @Override
    public void setFiletype(String filetype) {
    }

    @Override
    public boolean isLocked() {
        return false;
    }

    @Override
    public void setLocked(boolean lock) {
    }

    @Override
    public int getSize() {
        return AppleUtil.getWordValue(this.fileEntry, 28);
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    public List<RdosFileEntry> getFiles() {
        return null;
    }

    @Override
    public boolean isDeleted() {
        return AppleUtil.getUnsignedByte(this.fileEntry[0]) == 128;
    }

    @Override
    public void delete() {
    }

    @Override
    public List<String> getFileColumnData(int displayMode) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        ArrayList<String> list = new ArrayList<String>();
        switch (displayMode) {
            case 2: {
                list.add(this.getFiletype());
                numberFormat.setMinimumIntegerDigits(3);
                list.add(numberFormat.format(this.getSizeInBlocks()));
                list.add(this.getFilename());
                numberFormat.setMinimumIntegerDigits(1);
                list.add(numberFormat.format(this.getSize()));
                numberFormat.setMinimumIntegerDigits(3);
                list.add(numberFormat.format(this.getStartingBlock()));
                break;
            }
            case 3: {
                list.add(this.getFiletype());
                numberFormat.setMinimumIntegerDigits(3);
                list.add(numberFormat.format(this.getSizeInBlocks()));
                list.add(this.getFilename());
                numberFormat.setMinimumIntegerDigits(1);
                list.add(numberFormat.format(this.getSize()));
                numberFormat.setMinimumIntegerDigits(3);
                list.add(numberFormat.format(this.getStartingBlock()));
                list.add("$" + AppleUtil.getFormattedWord(this.getAddress()));
                list.add(this.isDeleted() ? this.textBundle.get("Deleted") : "");
                break;
            }
            default: {
                list.add(this.getFilename());
                list.add(this.getFiletype());
                list.add(numberFormat.format(this.getSize()));
                list.add(this.isLocked() ? this.textBundle.get("Locked") : "");
            }
        }
        return list;
    }

    @Override
    public byte[] getFileData() {
        byte[] rawdata = this.disk.getFileData(this);
        byte[] filedata = new byte[this.getSize()];
        System.arraycopy(rawdata, 0, filedata, 0, filedata.length);
        return filedata;
    }

    @Override
    public void setFileData(byte[] data) throws DiskFullException {
    }

    @Override
    public FileFilter getSuggestedFilter() {
        if (this.isApplesoftBasicFile()) {
            return new ApplesoftFileFilter();
        }
        if (this.isIntegerBasicFile()) {
            return new IntegerBasicFileFilter();
        }
        if (this.isTextFile()) {
            return new TextFileFilter();
        }
        if (this.isBinaryFile()) {
            int size = this.getSize();
            GraphicsFileFilter filter = new GraphicsFileFilter();
            if (size >= 8185 && size <= 8192) {
                filter.setMode(2);
                return filter;
            }
            if (size >= 16377 && size <= 16384) {
                filter.setMode(4);
                return filter;
            }
        }
        return new BinaryFileFilter();
    }

    public boolean isTextFile() {
        return "T".equals(this.getFiletype());
    }

    public boolean isApplesoftBasicFile() {
        return "A".equals(this.getFiletype());
    }

    public boolean isIntegerBasicFile() {
        return "I".equals(this.getFiletype());
    }

    public boolean isBinaryFile() {
        return "B".equals(this.getFiletype());
    }

    @Override
    public FormattedDisk getFormattedDisk() {
        return this.disk;
    }

    @Override
    public boolean needsAddress() {
        return this.disk.needsAddress(this.getFiletype());
    }

    @Override
    public void setAddress(int address) {
    }

    @Override
    public boolean canCompile() {
        return this.isApplesoftBasicFile();
    }
}

